import 'package:get_it/get_it.dart';
import 'package:demand/domain/interface/address.dart';
import 'package:demand/domain/interface/auth.dart';
import 'package:demand/domain/interface/banner.dart';
import 'package:demand/domain/interface/blog.dart';
import 'package:demand/domain/interface/booking.dart';
import 'package:demand/domain/interface/brands.dart';
import 'package:demand/domain/interface/cart.dart';
import 'package:demand/domain/interface/category.dart';
import 'package:demand/domain/interface/chat.dart';
import 'package:demand/domain/interface/form.dart';
import 'package:demand/domain/interface/gallery.dart';
import 'package:demand/domain/interface/master.dart';
import 'package:demand/domain/interface/order.dart';
import 'package:demand/domain/interface/parcel.dart';
import 'package:demand/domain/interface/payments.dart';
import 'package:demand/domain/interface/products.dart';
import 'package:demand/domain/interface/review.dart';
import 'package:demand/domain/interface/service.dart';
import 'package:demand/domain/interface/settings.dart';
import 'package:demand/domain/interface/shop.dart';
import 'package:demand/domain/interface/user.dart';
import 'package:demand/infrastructure/repository/address_repository.dart';
import 'package:demand/infrastructure/repository/auth_repository.dart';
import 'package:demand/infrastructure/repository/banners_repository.dart';
import 'package:demand/infrastructure/repository/blogs_repository.dart';
import 'package:demand/infrastructure/repository/booking_repository.dart';
import 'package:demand/infrastructure/repository/brands_repository.dart';
import 'package:demand/infrastructure/repository/cart_repository.dart';
import 'package:demand/infrastructure/repository/categories_repository.dart';
import 'package:demand/infrastructure/repository/chat_repository.dart';
import 'package:demand/infrastructure/repository/form_repository.dart';
import 'package:demand/infrastructure/repository/gallery_repository.dart';
import 'package:demand/infrastructure/repository/master_repository.dart';
import 'package:demand/infrastructure/repository/order_repository.dart';
import 'package:demand/infrastructure/repository/parcel_repository.dart';
import 'package:demand/infrastructure/repository/payments_repository.dart';
import 'package:demand/infrastructure/repository/products_repository.dart';
import 'package:demand/infrastructure/repository/review_repository.dart';
import 'package:demand/infrastructure/repository/service_repository.dart';
import 'package:demand/infrastructure/repository/settings_repository.dart';
import 'package:demand/infrastructure/repository/shops_repository.dart';
import 'package:demand/infrastructure/repository/user_repository.dart';
import 'package:demand/infrastructure/service/http_service.dart';

final GetIt getIt = GetIt.instance;

Future<void> setUpDependencies() async {
  getIt.registerLazySingleton<HttpService>(() => HttpService());
  getIt.registerSingleton<SettingsInterface>(SettingsRepository());
  getIt.registerSingleton<AuthInterface>(AuthRepository());
  getIt.registerSingleton<CategoryInterface>(CategoryRepository());
  getIt.registerSingleton<BannersInterface>(BannersRepository());
  getIt.registerSingleton<ProductsInterface>(ProductsRepository());
  getIt.registerSingleton<BlogInterface>(BlogsRepository());
  getIt.registerSingleton<ShopsInterface>(ShopsRepository());
  getIt.registerSingleton<BrandsInterface>(BrandsRepository());
  getIt.registerSingleton<GalleryInterface>(GalleryRepository());
  getIt.registerSingleton<UserInterface>(UserRepository());
  getIt.registerSingleton<ChatInterface>(ChatRepository());
  getIt.registerSingleton<AddressInterface>(AddressRepository());
  getIt.registerSingleton<CartInterface>(CartRepository());
  getIt.registerSingleton<ParcelInterface>(ParcelRepository());
  getIt.registerSingleton<ServiceInterface>(ServiceRepository());
  getIt.registerSingleton<PaymentsInterface>(PaymentsRepository());
  getIt.registerSingleton<OrderInterface>(OrderRepository());
  getIt.registerSingleton<ReviewInterface>(ReviewRepository());
  getIt.registerSingleton<MasterInterface>(MasterRepository());
  getIt.registerSingleton<BookingInterface>(BookingRepository());
  getIt.registerSingleton<FormOptionsInterface>(FormOptionsRepository());
}

final settingsRepository = getIt.get<SettingsInterface>();
final dioHttp = getIt.get<HttpService>();
final authRepository = getIt.get<AuthInterface>();
final categoriesRepository = getIt.get<CategoryInterface>();
final bannersRepository = getIt.get<BannersInterface>();
final productsRepository = getIt.get<ProductsInterface>();
final blogsRepository = getIt.get<BlogInterface>();
final shopsRepository = getIt.get<ShopsInterface>();
final brandsRepository = getIt.get<BrandsInterface>();
final galleryRepository = getIt.get<GalleryInterface>();
final userRepository = getIt.get<UserInterface>();
final chatRepository = getIt.get<ChatInterface>();
final addressRepository = getIt.get<AddressInterface>();
final cartRepository = getIt.get<CartInterface>();
final serviceRepository = getIt.get<ServiceInterface>();
final paymentsRepository = getIt.get<PaymentsInterface>();
final ordersRepository = getIt.get<OrderInterface>();
final reviewRepository = getIt.get<ReviewInterface>();
final parcelRepository = getIt.get<ParcelInterface>();
final masterRepository = getIt.get<MasterInterface>();
final bookingRepository = getIt.get<BookingInterface>();
final formRepository = getIt.get<FormOptionsInterface>();
